'Program name           2001BUF.BAS
'This program sets the Model 2001 to store 25 readings of DCV data
'QuickBasic 4.5 and PC-488-CEC
'DEC 4 / 92
CALL Initialize(21, 0)                      ' init as system controller
DATA$ = SPACE$(750)                         ' Set space for data
   CLS                                      ' Clear screen
REM *********** Set to DCV ***************************
   CALL Send(16, ":SENS:FUNC 'VOLT:DC'", Gpib.status%)
REM *********** Set to 2 Volt range ******************
   CALL Send(16, ":SENS:VOLT:DC:RANG 2", Gpib.status%)
REM *********** Set 5 digits resolution **************
   CALL Send(16, ":SENS:VOLT:DC:RES 5", Gpib.status%)
REM *********** Set type of data store mode **********
   CALL Send(16, ":TRAC:FEED CALC", Gpib.status%)
REM *********** Set buffer for 25 readings ***********
   CALL Send(16, ":TRAC:POIN 25", Gpib.status%)
REM *********** Set for complete data storage ********
   CALL Send(16, ":TRAC:EGR FULL", Gpib.status%)
REM *********** Set output format for ASCII **********
   CALL Send(16, ":FORM:DATA ASCII", Gpib.status%)
REM *********** Set format for readings only *********
   CALL Send(16, ":FORM:ELEM READ", Gpib.status%)
REM *********** Set buffer feed for FILL and Stop ****
   CALL Send(16, ":TRAC:FEED:CONT NEXT", Gpib.status%)
REM *********** Short wait ***************************
   FOR I = 1 TO 10000: NEXT I
REM *********** Send Trace Data Query ****************
   CALL Send(16, ":TRACE:DATA?", Gpib.status%)
REM *********** Address 2001 to talk *****************
   CALL Enter(DATA$, LENGTH%, 16, STATUS%)
REM *********** Simple routine to display readings in column form
   A = 3
   FOR I = 1 TO 25
        R2$ = MID$(DATA$, A, 11)
        PRINT R2$
        A = A + 14
   NEXT I
REM *********** End of program **********************  
    END


